<?php
/**
 * The Intro Page Template
 */ 
$epi_settings = get_option('elementor-page-intro_settings');
if(!isset($epi_settings['page_intro_id'])) { $epi_settings['page_intro_id'] = ''; }
$arg = array( 'page_id' => $epi_settings['page_intro_id'], 'post_type' => 'page');
query_posts( $arg );
while (have_posts()) : the_post();
$uploads = wp_upload_dir(); 
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<link rel="shortcut icon" href="<?php echo esc_url($epi_settings['favicon_url']); ?>">	
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<?php wp_head(); ?>  
</head>

<body id="pageintroelementor" <?php body_class(); ?>>

<?php echo the_content(); ?>
<link rel="stylesheet" type="text/css" href="<?php echo EPI_URL; ?>assets/css/main.css" /> 
<link rel="stylesheet" type="text/css" href="<?php echo esc_url($uploads['baseurl']); ?>/elementor/css/post-<?php echo esc_html($epi_settings['page_intro_id']); ?>.css" /> 
</body>

<?php wp_footer();
endwhile;
